<?php
	require('libs/fpdf/fpdf.php');
	session_start();
class eFPDF extends FPDF
{
    function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle=0)
    {
        $font_angle+=90+$txt_angle;
        $txt_angle*=M_PI/180;
        $font_angle*=M_PI/180;
        $txt_dx=cos($txt_angle);
        $txt_dy=sin($txt_angle);
        $font_dx=cos($font_angle);
        $font_dy=sin($font_angle);
        $s=sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET',$txt_dx,$txt_dy,$font_dx,$font_dy,$x*$this->k,($this->h-$y)*$this->k,$this->_escape($txt));
        if ($this->ColorFlag)
            $s='q '.$this->TextColor.' '.$s.' Q';
        $this->_out($s);
    }
  }
// -------------------------------------------------- //
//            ALLOCATE FPDF RESSOURCE
// -------------------------------------------------- //
	$pdf = new eFPDF('L', 'pt');        
    $pdf->AddPage();
    $pdf->SetFont('Arial','B',16);
        //$pdf->SetFillColor('221','221','221');
		//meter logo sociedad
        $pdf->SetFont('Arial','',12);
        $pdf->Ln();
        $pdf->SetFillColor('','','');
        $pdf->setXY(30,50);
        $pdf->Cell(1,0,$pdf->Image("images/svcprem-logo.png", 650,120,10),0,1,'R',0);
        $pdf->setXY(30,120);
		$pdf->SetFont('Arial','B',16);
        $pdf->Ln();
		$pdf->Cell(180,10, "SOCIEDAD VENEZOLANA DE CIRUGIA PLASTICA",0,1,'L',0);
        $pdf->Ln();
		$pdf->Cell(180,10, "RECONSTRUCTIVA Y MAXILOFACILA",0,1,'L',0);
		$pdf->setXY(30,200);
		$pdf->Ln(); 
        $pdf->Cell(200,10, "SU SELECCION DE VOTOS ES",0,1,'L',0);
		$pdf->Write(2, ("____________________________________________________________________________________")); 
        $pdf->Ln();
        $pdf->SetFont('Arial','B',18);
        $pdf->Ln();
        $pdf->setXY(30,250);
		if ($_SESSION["vvice"]=="1x1") {
			$pdf->Cell(50,30,"     Vicepresidente: CORALIA DE ALMEIDA",0,1,'L',0); 
			}
		else {
			$pdf->Cell(50,30,"     Vicepresidente: Voto Nulo",0,1,'L',0); 
		}
        $pdf->SetFont('Arial','B',18);
        if ($_SESSION["vvsecre"]=="2x1") {
			$pdf->Cell(50,30,"     Secretaria: MARIA ROSARIO FERMIN",0,1,'L',0); 
			}
		else {
			$pdf->Cell(50,30,"     Secretaria: Voto Nulo",0,1,'L',0); 
		}	
		$pdf->SetFont('Arial','B',18);
        if ($_SESSION["vvteso"]=="3x1") {
			$pdf->Cell(50,30,"     Tesorero: ATTILIO VILLARMOSA",0,1,'L',0); }
		else {
			$pdf->Cell(50,30,"     Tesorero: Voto Nulo",0,1,'L',0); 	
		}
		$pdf->SetFont('Arial','B',18);
		if ($_SESSION["vvocal7"]=="4x7") {
			$pdf->Cell(50,30,"     Vocal: NINGUNO",0,1,'L',0); }
		else {
			if ($_SESSION["vvocal1"]=="4x1") {
				$pdf->Cell(50,30,"     Vocal: THAIS GONZALEZ",0,1,'L',0);
				$pdf->Ln(2);
				$pdf->SetFont('Arial','B',18);				}
			if ($_SESSION["vvocal2"]=="4x2") {
				$pdf->Cell(50,30,"     Vocal: NATALIA SOLORZANO",0,1,'L',0); 
				$pdf->Ln(2);
				$pdf->SetFont('Arial','B',18);}
			if ($_SESSION["vvocal3"]=="4x3") {
				$pdf->Cell(50,30,"     Vocal: OTTO GONZALEZ",0,1,'L',0); 
				$pdf->Ln(2);
				$pdf->SetFont('Arial','B',18);}
			if ($_SESSION["vvocal4"]=="4x4") {
				$pdf->Cell(50,30,"     Vocal: JORGE CENTENO",0,1,'L',0); 
				$pdf->Ln(2);
				$pdf->SetFont('Arial','B',18);}
			if ($_SESSION["vvocal5"]=="4x5") {
				$pdf->Cell(50,30,"     Vocal: ALEJANDRA GUTIERREZ",0,1,'L',0); 
				$pdf->Ln(2);
				$pdf->SetFont('Arial','B',18);}
			if ($_SESSION["vvocal6"]=="4x6") {
				$pdf->Cell(50,30,"     Vocal: NIURKA CEDENO",0,1,'L',0); 
			$pdf->Ln(2);}
		}
        $pdf->Ln();
		$pdf->Ln();
		$pdf->Ln();
		date_default_timezone_set('America/Caracas');
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(200,30, " Fecha: ". date("d-m-Y h:i:s") ,0,1,'R',0);
        $pdf->Ln();
    $pdf->Output('tmp/'.$_SESSION["vidusu"].  '.pdf','f'); 	
	//session_unset();
	header("Content-type: application/pdf");
	header("Content-Disposition: inline; filename=votoemitido.pdf");
	readfile('tmp/'.$_SESSION["vidusu"].  '.pdf');
	//echo "<script> window.close();</script>";
?>