<?php
	require('libs/fpdf/fpdf.php');
	session_start();
class eFPDF extends FPDF
{
    function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle=0)
    {
        $font_angle+=90+$txt_angle;
        $txt_angle*=M_PI/180;
        $font_angle*=M_PI/180;
        $txt_dx=cos($txt_angle);
        $txt_dy=sin($txt_angle);
        $font_dx=cos($font_angle);
        $font_dy=sin($font_angle);
        $s=sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET',$txt_dx,$txt_dy,$font_dx,$font_dy,$x*$this->k,($this->h-$y)*$this->k,$this->_escape($txt));
        if ($this->ColorFlag)
            $s='q '.$this->TextColor.' '.$s.' Q';
        $this->_out($s);
    }
  }
// -------------------------------------------------- //
//            ALLOCATE FPDF RESSOURCE
// -------------------------------------------------- //
	$pdf = new eFPDF('L', 'pt','Letter');        
    $pdf->AddPage();
    $pdf->SetFont('Arial','B',16);
        //$pdf->SetFillColor('221','221','221');
		//meter logo sociedad
        $pdf->SetFont('Arial','',12);
        $pdf->Ln();
        //$pdf->SetFillColor('','','');
        $pdf->setXY(30,50);
        $pdf->Cell(0,0,$pdf->Image("images/logo1.png", 650,120,10),0,1,'L',0);
        $pdf->setXY(30,120);
		$pdf->SetFont('Arial','B',16);
        $pdf->Ln();
		$pdf->Cell(180,10, "SOCIEDAD VENEZOLANA DE ENDOCRINOLOGIA Y METABOLISMO",0,1,'L',0);
		$pdf->setXY(30,200);
		$pdf->Ln(); 
        $pdf->Cell(200,10, "SU SELECCION DE VOTOS ES",0,1,'L',0);
		$pdf->Write(2, ("____________________________________________________________________________________")); 
        $pdf->Ln();
        $pdf->SetFont('Arial','B',18);
        $pdf->Ln();
        $pdf->setXY(30,250);
		$pdf->Cell(0,30,'No de Acuerdo',0,1,'L',0); 
		$pdf->Ln();
		date_default_timezone_set('America/Caracas');
        $pdf->SetFont('Arial','B',12);
        $pdf->Cell(0,30, " Fecha: ". date("d-m-Y h:i:s") ,0,1,'R',0);
        $pdf->Ln();
    $pdf->Output('tmp/'.$_SESSION["id_usuario"].  '.pdf','f'); 	
	//session_unset();
	header("Content-type: application/pdf");
	header("Content-Disposition: inline; filename=votoemitido.pdf");
	readfile('tmp/'.$_SESSION["id_usuario"].  '.pdf');
	session_destroy();
	session_write_close();
	echo "<script> window.close();</script>";
?>